<?php 
return [
  'title' => 'Справочник по API',
  'subtitle' => 'Документация разработчика',
  'intro' => 'Добро пожаловать в полный справочник по API. Эта система обеспечивает глубокую интеграцию с серверной частью POS, что позволяет вам создавать приложения для официантов, киоски для клиентов или настраиваемые информационные панели.',
  'search_placeholder' => 'Поиск конечных точек...',
  'base_url' => 'Базовый URL',
  'auth_header' => 'Аутентификация',
  'auth_desc' => 'Аутентификация через токен на предъявителя. Включите `Authorization: Bearer <token>` в заголовки.',
  'sections' => [
    'auth' => 'Аутентификация',
    'platform' => 'Платформа',
    'resources' => 'Ресурсы',
    'customers' => 'Клиенты',
    'catalog' => 'Каталог',
    'sales' => 'Продажи и заказы',
    'kot' => 'Кухонные заказы (КОТ)',
    'delivery' => 'Управление доставкой',
    'operations' => 'Операции',
    'hardware' => 'Оборудование и устройства',
    'pusher' => 'В режиме реального времени и push-уведомления',
  ],
  'endpoints' => [
    'login' => [
      'title' => 'Авторизоваться',
      'desc' => 'Получите токен доступа.',
    ],
    'me' => [
      'title' => 'Профиль пользователя',
      'desc' => 'Получить текущего пользователя и разрешения.',
    ],
    'config' => [
      'title' => 'Конфигурация и функции',
      'desc' => 'Получите настройки системы, флаги функций и активные модули.',
    ],
    'permissions' => [
      'title' => 'Разрешения',
      'desc' => 'Перечислите роли и возможности пользователей.',
    ],
    'printers' => [
      'title' => 'Принтеры',
      'desc' => 'Получите настроенные принтеры чеков/KOT.',
    ],
    'receipts' => [
      'title' => 'Настройки получения',
      'desc' => 'Получите конфигурацию стиля чека.',
    ],
    'switch_branch' => [
      'title' => 'Переключить филиал',
      'desc' => 'Измените контекст активной ветки.',
    ],
    'langs' => [
      'title' => 'Языки',
      'desc' => 'Получите доступные языки.',
    ],
    'currencies' => [
      'title' => 'Валюты',
      'desc' => 'Получить системные валюты.',
    ],
    'gateways' => [
      'title' => 'Платежные шлюзы',
      'desc' => 'Получите учетные данные общедоступного шлюза.',
    ],
    'staff' => [
      'title' => 'Список сотрудников',
      'desc' => 'Соберите всех сотрудников.',
    ],
    'roles' => [
      'title' => 'Роли',
      'desc' => 'Получите доступные роли пользователей.',
    ],
    'areas' => [
      'title' => 'Области',
      'desc' => 'Получите площади плана этажа.',
    ],
    'addr_list' => [
      'title' => 'Получение списка адресов',
      'desc' => 'Получите адреса клиентов.',
    ],
    'addr_create' => [
      'title' => 'Создать адрес',
      'desc' => 'Добавьте новый адрес доставки.',
    ],
    'addr_update' => [
      'title' => 'Обновить адрес',
      'desc' => 'Изменить существующий адрес.',
    ],
    'addr_delete' => [
      'title' => 'Удалить адрес',
      'desc' => 'Удалить адрес.',
    ],
    'menus' => [
      'title' => 'Меню',
      'desc' => 'Получите активное меню.',
    ],
    'categories' => [
      'title' => 'Категории',
      'desc' => 'Получить категории товаров.',
    ],
    'items' => [
      'title' => 'Все предметы',
      'desc' => 'Получите полный каталог товаров с ценами и модификаторами.',
    ],
    'items_filter' => [
      'title' => 'Фильтровать элементы',
      'desc' => 'Получайте товары по категориям или меню.',
    ],
    'variations' => [
      'title' => 'Варианты предметов',
      'desc' => 'Получите варианты для конкретного элемента.',
    ],
    'modifiers' => [
      'title' => 'Модификаторы предметов',
      'desc' => 'Получите группы модификаторов для конкретного элемента.',
    ],
    'orders_create' => [
      'title' => 'Отправить заказ',
      'desc' => 'Создайте новый заказ (Dine-in/Delivery).',
    ],
    'orders_list' => [
      'title' => 'Список заказов',
      'desc' => 'Получить историю заказов.',
    ],
    'orders_detail' => [
      'title' => 'Детали заказа',
      'desc' => 'Получите объект полного заказа.',
    ],
    'orders_status' => [
      'title' => 'Обновить статус',
      'desc' => 'Изменить статус заказа (например, подготовлен).',
    ],
    'orders_pay' => [
      'title' => 'Платежный заказ',
      'desc' => 'Зафиксируйте оплату и закройте заказ.',
    ],
    'order_number' => [
      'title' => 'Номер предварительного просмотра',
      'desc' => 'Получите номер следующего заказа.',
    ],
    'order_types' => [
      'title' => 'Типы ордеров',
      'desc' => 'Получить типы (обед, еда на вынос).',
    ],
    'actions' => [
      'title' => 'Разрешенные действия',
      'desc' => 'Получите действительные действия заказа (кот, счет).',
    ],
    'platforms' => [
      'title' => 'Платформы доставки',
      'desc' => 'Приобретайте сторонние платформы.',
    ],
    'charges' => [
      'title' => 'Дополнительные сборы',
      'desc' => 'Получите плату за обслуживание/комиссию.',
    ],
    'taxes' => [
      'title' => 'Налоги',
      'desc' => 'Получите настроенные налоговые ставки.',
    ],
    'tables' => [
      'title' => 'Таблицы',
      'desc' => 'Получите статус таблицы в реальном времени.',
    ],
    'unlock' => [
      'title' => 'Разблокировать стол',
      'desc' => 'Принудительно разблокировать стол.',
    ],
    'res_today' => [
      'title' => 'Сегодняшние бронирования',
      'desc' => 'Получите резервирование для панели управления.',
    ],
    'res_list' => [
      'title' => 'Все бронирования',
      'desc' => 'Получите постраничное резервирование.',
    ],
    'res_create' => [
      'title' => 'Создать бронирование',
      'desc' => 'Забронируйте столик.',
    ],
    'res_status' => [
      'title' => 'Обновить бронирование',
      'desc' => 'Изменить статус бронирования.',
    ],
    'cust_search' => [
      'title' => 'Поиск клиентов',
      'desc' => 'Найти по имени/телефону.',
    ],
    'cust_save' => [
      'title' => 'Сохранить клиента',
      'desc' => 'Создайте или обновите профиль.',
    ],
    'waiters' => [
      'title' => 'Официанты',
      'desc' => 'Наберите персонал на должности официантов/водителей.',
    ],
    'kot_list' => [
      'title' => 'Список КОТ',
      'desc' => 'Получите талоны на заказ кухни для показа.',
    ],
    'kot_detail' => [
      'title' => 'КОТ Деталь',
      'desc' => 'Получите один KOT с предметами.',
    ],
    'kot_create' => [
      'title' => 'Создать КОТ',
      'desc' => 'Создайте новый КОТ для существующего заказа.',
    ],
    'kot_status' => [
      'title' => 'Обновить статус KOT',
      'desc' => 'Изменить статус КОТ (in_kitchen, food_ready, подано, отменено).',
    ],
    'kot_item_status' => [
      'title' => 'Обновить статус элемента',
      'desc' => 'Обновить статус отдельного блюда (приготовление, готовность, отменено).',
    ],
    'kot_places' => [
      'title' => 'Кухонные места',
      'desc' => 'Получите кухонные станции/места.',
    ],
    'kot_cancel_reasons' => [
      'title' => 'Причины отмены',
      'desc' => 'Узнайте причины отмены KOT.',
    ],
    'order_kots' => [
      'title' => 'Заказать КОТ',
      'desc' => 'Получите все КОТы для конкретного заказа.',
    ],
    'delivery_settings' => [
      'title' => 'Настройки доставки',
      'desc' => 'Получите конфигурацию доставки филиалов (радиус, комиссия, график).',
    ],
    'delivery_fee_calc' => [
      'title' => 'Рассчитать комиссию',
      'desc' => 'Рассчитайте стоимость доставки в зависимости от местоположения клиента.',
    ],
    'delivery_fee_tiers' => [
      'title' => 'Уровни комиссий',
      'desc' => 'Получите уровни оплаты на основе расстояния.',
    ],
    'delivery_platforms_list' => [
      'title' => 'Получение списка платформ',
      'desc' => 'Приобретите активные платформы доставки (Uber Eats и т. д.).',
    ],
    'delivery_platform_get' => [
      'title' => 'Детали платформы',
      'desc' => 'Получите единую платформу доставки с информацией о комиссии.',
    ],
    'delivery_platform_create' => [
      'title' => 'Создать платформу',
      'desc' => 'Добавить новую платформу доставки.',
    ],
    'delivery_platform_update' => [
      'title' => 'Обновить платформу',
      'desc' => 'Изменить настройки/комиссию платформы.',
    ],
    'delivery_platform_delete' => [
      'title' => 'Удалить платформу',
      'desc' => 'Удалите или деактивируйте платформу доставки.',
    ],
    'delivery_exec_list' => [
      'title' => 'Список руководителей',
      'desc' => 'Получите персонал доставки с фильтром статуса.',
    ],
    'delivery_exec_create' => [
      'title' => 'Создать руководителя',
      'desc' => 'Добавить нового менеджера по доставке.',
    ],
    'delivery_exec_update' => [
      'title' => 'Обновление руководителя',
      'desc' => 'Изменить информацию об исполнителе доставки.',
    ],
    'delivery_exec_delete' => [
      'title' => 'Удалить руководителя',
      'desc' => 'Удалить или деактивировать менеджера по доставке.',
    ],
    'delivery_exec_status' => [
      'title' => 'Исполнительный статус',
      'desc' => 'Доступность обновления (доступно/при доставке/неактивно).',
    ],
    'delivery_assign' => [
      'title' => 'Назначить доставку',
      'desc' => 'Назначьте руководителя/платформу по заказу.',
    ],
    'delivery_order_status' => [
      'title' => 'Статус доставки',
      'desc' => 'Обновить статус доставки заказа (готовится, out_for_delivery, доставлено).',
    ],
    'delivery_orders' => [
      'title' => 'Заказы на доставку',
      'desc' => 'Получите отфильтрованный список заказов на доставку.',
    ],
    'multipos_reg' => [
      'title' => 'Зарегистрировать устройство',
      'desc' => 'Подключите физическое оборудование.',
    ],
    'multipos_check' => [
      'title' => 'Проверить устройство',
      'desc' => 'Подтвердить регистрацию.',
    ],
    'notif_token' => [
      'title' => 'Зарегистрировать ФСМ',
      'desc' => 'Сохраните push-токен.',
    ],
    'notif_list' => [
      'title' => 'Уведомления',
      'desc' => 'Получайте оповещения в приложении.',
    ],
    'notif_read' => [
      'title' => 'Марк Рид',
      'desc' => 'Закрыть уведомление.',
    ],
    'pusher_settings' => [
      'title' => 'Получить настройки толкателя',
      'desc' => 'Получите полную конфигурацию Pusher. Доступно для всех аутентифицированных пользователей (суперадминистратора, администратора, сотрудников).',
    ],
    'pusher_broadcast' => [
      'title' => 'Получить настройки трансляции',
      'desc' => 'Получите конфигурацию трансляции Pusher в реальном времени. Общесистемные настройки для всех пользователей.',
    ],
    'pusher_beams' => [
      'title' => 'Получить настройки лучей',
      'desc' => 'Получите конфигурацию push-уведомлений Pusher Beams. Доступен всем авторизованным пользователям.',
    ],
    'pusher_status' => [
      'title' => 'Проверьте статус толкателя',
      'desc' => 'Быстрая проверка статуса, чтобы убедиться, что службы Pusher включены. Доступно всем пользователям.',
    ],
    'pusher_authorize' => [
      'title' => 'Авторизовать канал',
      'desc' => 'Разрешите пользователю доступ к частным каналам и каналам присутствия. Требуется действительная аутентификация.',
    ],
    'pusher_presence' => [
      'title' => 'Получить участников присутствия',
      'desc' => 'Получить список пользователей, которые в данный момент подключены к каналу присутствия. Общесистемные данные.',
    ],
  ],
];